<?php
session_start();
define('BASE_PATH', dirname(__DIR__));

// === MODELS ===
// Hanya require model yang benar-benar ada dan dipakai
require_once BASE_PATH . '/app/models/AuthModel.php';
require_once BASE_PATH . '/app/models/ProdiModel.php';
require_once BASE_PATH . '/app/models/DosenModel.php';
require_once BASE_PATH . '/app/models/RuanganModel.php';
require_once BASE_PATH . '/app/models/MataKuliahModel.php';
require_once BASE_PATH . '/app/models/PengajuanModel.php';
require_once BASE_PATH . '/app/models/BookingModel.php';
require_once BASE_PATH . '/app/models/JadwalModel.php';        // ✅
require_once BASE_PATH . '/app/models/UserModel.php';
require_once BASE_PATH . '/app/models/LogModel.php';
require_once BASE_PATH . '/app/models/KelasModel.php';         // ✅
require_once BASE_PATH . '/app/models/HariModel.php';          // ✅
require_once BASE_PATH . '/app/models/SlotModel.php';          // ✅

// === CONTROLLERS ===
require_once BASE_PATH . '/app/controllers/AuthController.php';
require_once BASE_PATH . '/app/controllers/DashboardController.php';
require_once BASE_PATH . '/app/controllers/ProdiController.php';
require_once BASE_PATH . '/app/controllers/DosenController.php';
require_once BASE_PATH . '/app/controllers/RuanganController.php';
require_once BASE_PATH . '/app/controllers/MataKuliahController.php';
require_once BASE_PATH . '/app/controllers/PengajuanController.php';
require_once BASE_PATH . '/app/controllers/BookingController.php';
require_once BASE_PATH . '/app/controllers/JadwalController.php'; // ✅
require_once BASE_PATH . '/app/controllers/UserController.php';
require_once BASE_PATH . '/app/controllers/LogController.php';
require_once BASE_PATH . '/app/controllers/KelasController.php';  // ✅

// === INSTANCES ===
$auth = new AuthController();
$dashboard = new DashboardController();
$prodi = new ProdiController();
$dosen = new DosenController();
$ruangan = new RuanganController();
$mk = new MataKuliahController();
$pengajuan = new PengajuanController();
$booking = new BookingController();
$jadwal = new JadwalController();     // ✅
$user = new UserController();
$log = new LogController();
$kelas = new KelasController();       // ✅

$route = $_GET['route'] ?? '';

switch ($route) {
    case 'login':  $auth->login();  exit;
    case 'logout': $auth->logout(); exit;

    // === KELAS ===
    case 'kelas':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $kelas->index();  exit;
    case 'kelas_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $kelas->add();    exit;
    case 'kelas_edit':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $kelas->edit();   exit;
    case 'kelas_delete': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $kelas->delete(); exit;

    // === PRODI ===
    case 'prodi':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $prodi->index();  exit;
    case 'prodi_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $prodi->add();    exit;
    case 'prodi_edit':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $prodi->edit();   exit;
    case 'prodi_delete': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $prodi->delete(); exit;

    // === DOSEN ===
    case 'dosen':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $dosen->index();  exit;
    case 'dosen_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $dosen->add();    exit;
    case 'dosen_edit':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $dosen->edit();   exit;
    case 'dosen_delete': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $dosen->delete(); exit;

    // === RUANGAN ===
    case 'ruangan':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $ruangan->index();  exit;
    case 'ruangan_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $ruangan->add();    exit;
    case 'ruangan_edit':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $ruangan->edit();   exit;
    case 'ruangan_delete': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $ruangan->delete(); exit;

    // === MATA KULIAH ===
    case 'mk':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $mk->index();  exit;
    case 'mk_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $mk->add();    exit;
    case 'mk_edit':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $mk->edit();   exit;
    case 'mk_delete': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $mk->delete(); exit;

    // === PENGAJUAN ===
    case 'pengajuan':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $pengajuan->index();  exit;
    case 'pengajuan_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $pengajuan->add();    exit;
    case 'pengajuan_approve':if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $pengajuan->approve();exit;
    case 'pengajuan_reject': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $pengajuan->reject(); exit;

    // === BOOKING ===
    case 'booking':         if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $booking->index();   exit;
    case 'booking_add':     if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $booking->add();     exit;
    case 'booking_approve': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $booking->approve(); exit;
    case 'booking_reject':  if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $booking->reject();  exit;

    // === JADWAL ===
    case 'jadwal':          if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $jadwal->index();    exit;
    case 'jadwal_edit':     if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $jadwal->edit();     exit;
    case 'jadwal_delete':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $jadwal->delete();   exit;

    // === USER ===
    case 'user':        if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $user->index();  exit;
    case 'user_add':    if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $user->add();    exit;
    case 'user_edit':   if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $user->edit();   exit;
    case 'user_delete': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $user->delete(); exit;
    case 'user_toggle': if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $user->toggle(); exit;

    // === LOG ===
    case 'log':             if (empty($_SESSION['user'])) { header("Location: index.php?route=login"); exit; } $log->index();       exit;

    // === DEFAULT ===
    default:
        if (!empty($_SESSION['user'])) { $dashboard->index(); exit; }
        header("Location: index.php?route=login"); exit;
}