<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
.topbar{background:#0f766e;color:#fff;padding:14px 28px;font-weight:600;}
.container{max-width:1100px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);}
a.btn,button.btn{padding:8px 12px;border-radius:10px;text-decoration:none;font-weight:600;border:none;cursor:pointer;display:inline-block}
.btn-add{background:#2563eb;color:#fff;}
.btn-edit{background:#0891b2;color:#fff;}
.btn-del{background:#ef4444;color:#fff;}
.btn-toggle{background:#10b981;color:#fff;}
.small{color:#64748b;font-size:.85rem}
table{width:100%;border-collapse:collapse;margin-top:16px}
th,td{padding:10px;border-bottom:1px solid #e2e8f0;text-align:left}
th{background:#f1f5f9}
.badge{background:#e2e8f0;border-radius:999px;padding:4px 10px;font-size:.8rem}
</style>

<div class="topbar">Manajemen User</div>
<div class="container">
  <a href="index.php?route=user_add" class="btn btn-add">+ Tambah User</a>

  <table>
    <tr>
      <th>ID</th><th>Username</th><th>Nama</th><th>Role</th><th>Ref</th><th>Email</th><th>Aktif</th><th>Aksi</th>
    </tr>
    <?php if (empty($list)): ?>
      <tr><td colspan="8" style="text-align:center;color:#64748b;padding:18px;">Belum ada user.</td></tr>
    <?php else: foreach($list as $u): ?>
      <tr>
        <td><span class="badge"><?= (int)$u['id_user'] ?></span></td>
        <td><?= htmlspecialchars($u['username']) ?></td>
        <td><?= htmlspecialchars($u['nama_lengkap']) ?></td>
        <td><?= htmlspecialchars($u['role']) ?></td>
        <td class="small">
          <?php if ($u['role']==='prodi'): ?>
            Prodi: <?= htmlspecialchars($u['nama_prodi'] ?? '-') ?>
          <?php elseif ($u['role']==='dosen'): ?>
            Dosen: <?= htmlspecialchars($u['nama_dosen_ref'] ?? '-') ?>
          <?php else: ?>
            -
          <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($u['email'] ?? '-') ?></td>
        <td><?= $u['aktif'] ? 'Aktif' : 'Nonaktif' ?></td>
        <td>
          <a class="btn btn-edit" href="index.php?route=user_edit&id=<?= (int)$u['id_user'] ?>">Edit</a>
          <a class="btn btn-toggle" href="index.php?route=user_toggle&id=<?= (int)$u['id_user'] ?>" onclick="return confirm('Ubah status aktif?')"><?= $u['aktif']?'Nonaktifkan':'Aktifkan' ?></a>
          <a class="btn btn-del" href="index.php?route=user_delete&id=<?= (int)$u['id_user'] ?>" onclick="return confirm('Hapus user ini?')">Hapus</a>
        </td>
      </tr>
    <?php endforeach; endif; ?>
  </table>

  <p style="margin-top:20px;"><a href="index.php">← Kembali ke Dashboard</a></p>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>
