<?php include BASE_PATH . '/app/views/layouts/header.php'; ?>

<div style="max-width:900px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);">
    <h2>➕ Tambah Ruangan Baru</h2>

    <?php if (isset($_SESSION['message'])): ?>
        <div style="padding:12px;background:<?= $_SESSION['message']['type'] === 'success' ? '#d1fae5' : '#fee2e2' ?>;color:<?= $_SESSION['message']['type'] === 'success' ? '#065f46' : '#991b1b' ?>;border-radius:8px;margin-bottom:20px;">
            <?= htmlspecialchars($_SESSION['message']['text']) ?>
        </div>
        <?php unset($_SESSION['message']); ?>
    <?php endif; ?>

    <form method="POST" action="">
        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Kode Ruangan</label>
            <input type="text" name="kode_ruangan" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" maxlength="20" required placeholder="Contoh: LAB-01">
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Gedung</label>
            <select name="id_gedung" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="">-- Pilih Gedung --</option>
                <?php foreach ($gedungList as $g): ?>
                    <option value="<?= (int)$g['id_gedung'] ?>">
                        <?= htmlspecialchars($g['nama_gedung']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Kapasitas</label>
            <input type="number" name="kapasitas" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" min="1" required placeholder="Contoh: 30">
        </div>

        <!-- ✅ TAMBAHKAN KOLOM LOKASI -->
        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Lokasi</label>
            <input type="text" name="lokasi" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" maxlength="100" required placeholder="Contoh: Lantai 2, Sayap Barat">
        </div>

        <!-- ✅ TAMBAHKAN KOLOM KETERANGAN -->
        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Keterangan (Optional)</label>
            <textarea name="keterangan" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" rows="4" placeholder="Contoh: Dilengkapi proyektor dan AC"></textarea>
        </div>

        <button type="submit" style="padding:12px 24px;background:#2563eb;color:#fff;border:none;border-radius:8px;font-weight:600;cursor:pointer;">Simpan Ruangan</button>
        <a href="index.php?route=ruangan" style="margin-left:10px;padding:12px 24px;background:#9ca3af;color:#fff;text-decoration:none;border-radius:8px;font-weight:600;">Batal</a>
    </form>
</div>

<?php include BASE_PATH . '/app/views/layouts/footer.php'; ?>