<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<div style="max-width:900px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);">
  <h2 style="color:#1e3a8a;margin-top:0;">Buat Pengajuan Jadwal</h2>
  <form method="post" action="index.php?route=pengajuan_add" autocomplete="off" style="display:grid;grid-template-columns:1fr 1fr;gap:16px;">
    <div>
      <label>Prodi</label>
      <select name="id_prodi" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Prodi --</option>
        <?php foreach($prodiList as $p): ?>
          <option value="<?= (int)$p['id_prodi'] ?>"><?= htmlspecialchars($p['nama_prodi']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Kelas</label>
      <select name="id_kelas" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Kelas --</option>
        <?php foreach($kelasList as $k): ?>
          <option value="<?= (int)$k['id_kelas'] ?>"><?= htmlspecialchars($k['kode_kelas']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Mata Kuliah</label>
      <select name="id_mk" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Mata Kuliah --</option>
        <?php foreach($mkList as $m): ?>
          <option value="<?= (int)$m['id_mk'] ?>"><?= htmlspecialchars($m['nama_mk']) ?> — <?= htmlspecialchars($m['nama_prodi']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Dosen</label>
      <select name="id_dosen" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Dosen --</option>
        <?php foreach($dosenList as $d): ?>
          <option value="<?= (int)$d['id_dosen'] ?>"><?= htmlspecialchars($d['nama_lengkap']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Ruangan</label>
      <select name="id_ruangan" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Ruangan --</option>
        <?php foreach($ruangList as $r): ?>
          <option value="<?= (int)$r['id_ruangan'] ?>"><?= htmlspecialchars($r['kode_ruangan']) ?> — <?= htmlspecialchars($r['nama_gedung']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Hari</label>
      <select name="id_hari" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Hari --</option>
        <?php foreach($hariList as $h): ?>
          <option value="<?= (int)$h['id_hari'] ?>"><?= htmlspecialchars($h['nama_hari']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Slot Waktu</label>
      <select name="id_slot" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Slot --</option>
        <?php foreach($slotList as $s): ?>
          <option value="<?= (int)$s['id_slot'] ?>"><?= substr($s['jam_mulai'],0,5) ?>–<?= substr($s['jam_selesai'],0,5) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Jumlah SKS</label>
      <select name="jumlah_sks" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="1">1</option><option value="2" selected>2</option><option value="3">3</option>
      </select>
    </div>

    <div>
      <label>Tanggal Mulai</label>
      <input type="date" name="tanggal_mulai" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
    </div>

    <div>
      <label>Tanggal Selesai</label>
      <input type="date" name="tanggal_selesai" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
    </div>

    <div style="grid-column:1 / span 2">
      <label>Keterangan (opsional)</label>
      <textarea name="keterangan" rows="3" style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;"></textarea>
    </div>

    <div style="grid-column:1 / span 2">
      <button style="background:#2563eb;color:#fff;padding:10px 18px;border:none;border-radius:10px;cursor:pointer;">Kirim Pengajuan</button>
      <a href="index.php?route=pengajuan" style="margin-left:10px;color:#475569;text-decoration:none;">Batal</a>
    </div>
  </form>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>
