<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
.wrap {
  max-width: 1200px;
  margin: 32px auto;
}
h2 {
  font-size: 1.5rem;
  color: #1e3a8a;
  font-weight: 700;
  display: flex;
  align-items: center;
  gap: 8px;
}
.summary {
  display: flex;
  gap: 20px;
  margin: 20px 0;
}
.card-summary {
  flex: 1;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 4px 14px rgba(0,0,0,0.08);
  padding: 20px;
  text-align: center;
}
.card-summary h3 {
  font-size: 1.1rem;
  color: #1e3a8a;
  margin-bottom: 6px;
}
.card-summary p {
  font-size: 1.6rem;
  font-weight: 700;
  color: #111827;
}

.header-hari {
  display: flex;
  background: #4f46e5;
  border-radius: 16px;
  overflow: hidden;
  margin-top: 20px;
  padding: 0;
}
.header-hari div {
  flex: 1;
  color: white;
  text-align: center;
  padding: 12px;
  font-weight: 600;
}
.footer-btn {
  text-align: right;
  margin-top: 20px;
}
.btn-back {
  color: #111827;
  font-weight: 500;
  text-decoration: none;
  font-size: 0.95rem;
  transition: color 0.2s ease;
}
.btn-back:hover {
  color: #2563eb;
  text-decoration: underline;
}
</style>

<div class="wrap">
  <h2>📅 Tabel Okupansi Jadwal Perkuliahan (Mingguan)</h2>

  <?php
  // ==========================
  // FILTER OTOMATIS MINGGU INI
  // ==========================
  $today = date('Y-m-d');
  $monday = date('Y-m-d', strtotime('monday this week', strtotime($today)));
  $sunday = date('Y-m-d', strtotime('sunday this week', strtotime($today)));

  echo "<p style='color:#6b7280;margin-bottom:12px;'>Periode: <strong>"
    . date('d M Y', strtotime($monday))
    . "</strong> - <strong>"
    . date('d M Y', strtotime($sunday))
    . "</strong></p>";

  // ==========================
  // HITUNG RUANGAN TERPAKAI DAN TERSEDIA
  // ==========================
  $totalRuangan = count($ruanganList ?? []); // misal dari DB
  $ruanganTerpakai = [];

  foreach ($list as $r) {
    if (!isset($r['tanggal'])) continue;

    $tgl = $r['tanggal'];
    if ($tgl >= $monday && $tgl <= $sunday) {
      $ruanganTerpakai[$r['kode_ruangan']] = true;
    }
  }

  $jumlahTerpakai = count($ruanganTerpakai);
  $jumlahTersedia = max(0, $totalRuangan - $jumlahTerpakai);
  ?>

  <div class="summary">
    <div class="card-summary">
      <h3>Ruang Terpakai</h3>
      <p><?= $jumlahTerpakai ?></p>
    </div>
    <div class="card-summary">
      <h3>Ruang Tersedia</h3>
      <p><?= $jumlahTersedia ?></p>
    </div>
    <div class="card-summary">
      <h3>Total Ruangan</h3>
      <p><?= $totalRuangan ?></p>
    </div>
  </div>

  <!-- HEADER HARI SAJA (Tanpa Tabel Jam) -->
  <div class="header-hari">
    <div>Jam</div>
    <?php foreach ($hariList as $h): ?>
      <div><?= htmlspecialchars($h['nama_hari']) ?></div>
    <?php endforeach; ?>
  </div>

  <!-- PESAN UNTUK DEVELOPER -->
  <div style="margin-top: 20px; padding: 20px; background: #fef3c7; border: 1px solid #f59e0b; border-radius: 8px; font-size: 0.9rem;">
    <strong>ℹ️ Catatan:</strong><br>
    Fitur tabel jadwal per jam (slot waktu) sedang dinonaktifkan karena ada error.<br>
    Untuk mengaktifkannya kembali:<br>
    1. Pastikan file <code>SlotModel.php</code> ada dan query <code>slot_waktu</code> berhasil.<br>
    2. Pastikan variabel <code>$slotList</code> dikirim dari controller.<br>
    3. Pastikan kolom <code>tanggal</code> ada di tabel <code>jadwal</code>.
  </div>

  <div class="footer-btn">
    <a href="index.php" class="btn-back">← Kembali ke Dashboard</a>
  </div>
</div>

<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>