<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
  .topbar{background:#4f46e5;color:#fff;padding:14px 28px;font-weight:600;border-radius:12px}
  .wrap{max-width:1200px;margin:24px auto;padding:0 8px}
  .card{background:#fff;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);padding:18px}
  .formgrid{display:grid;grid-template-columns:repeat(6,1fr);gap:10px}
  .formgrid input,.formgrid select{padding:10px;border:1px solid #cbd5e1;border-radius:10px}
  .btn{padding:10px 14px;border-radius:10px;border:none;background:#2563eb;color:#fff;font-weight:600;cursor:pointer}
  .btn-light{background:#e2e8f0;color:#111827}

  /* Tabs hari */
  .tabs{display:flex;gap:8px;flex-wrap:wrap;margin:6px 0 12px}
  .tab-btn{border:1px solid #e5e7eb;background:#fff;border-radius:10px;padding:8px 12px;cursor:pointer}
  .tab-btn.active{background:#2563eb;color:#fff;border-color:#2563eb}
  .tab-sub{display:block;font-size:.8rem;opacity:.85}

  /* GRID OKUPANSI */
  .occ-table{width:100%; border-collapse:separate; border-spacing:0; table-layout:fixed}
  .occ-table th,.occ-table td{border:1px solid #e5e7eb; padding:10px; vertical-align:top}
  .occ-table thead th{position:sticky; top:0; background:#f8fafc; z-index:2; font-weight:700}
  .occ-sticky-col{position:sticky; left:0; z-index:1; background:#fff; width:220px}
  .occ-free{color:#059669; background:rgba(16,185,129,.08); border:1px dashed #10b981; border-radius:10px; padding:8px; text-align:center}
  .occ-badge{display:inline-block; padding:2px 8px; border-radius:999px; font-size:.75rem; color:#fff; margin-left:6px}
  .occ-badge.tetap{background:#2563eb}
  .occ-badge.pengganti{background:#16a34a}
  .occ-cell-title{font-weight:700; margin-bottom:4px}
  .occ-cell-sub{font-size:.85rem; color:#64748b}
  .occ-room-head small{display:block; color:#6b7280; font-weight:400}
  .occ-legend{font-size:.85rem; color:#64748b; display:flex; gap:16px; align-items:center; margin:8px 0 12px}
  .dot{width:10px; height:10px; border-radius:50%; display:inline-block; margin-right:6px}
  .dot-blue{background:#2563eb}.dot-green{background:#16a34a}.dot-free{background:#10b981}
  .util{font-size:.85rem; color:#111827; background:#f1f5f9; border-radius:8px; padding:6px 10px; display:inline-block; margin-top:6px}
  .small{font-size:.85rem;color:#64748b}
  .kw{font-weight:700}

  /* halaman per-hari */
  .day-panel{display:none}
  .day-panel.active{display:block}

  /* Pager 2 halaman sesi */
  .pager{display:flex;gap:8px;align-items:center;justify-content:flex-end;margin:8px 0}
  .pager .btn-page{border:1px solid #e5e7eb;background:#fff;border-radius:8px;padding:6px 10px;cursor:pointer}
  .pager .btn-page.active{background:#2563eb;color:#fff;border-color:#2563eb}
  .page{display:none}
  .page.active{display:block}
  .page-hint{font-size:.85rem;color:#64748b;margin:6px 0 10px 0}
</style>

<div class="wrap">
  <div class="topbar">Jadwal Perkuliahan</div>

  <!-- FILTERS -->
  <div class="card" style="margin-top:12px;">
    <form method="get" action="index.php" class="formgrid" id="filterForm">
      <input type="hidden" name="route" value="jadwal">

      <select name="id_prodi">
        <option value="0">Semua Prodi</option>
        <?php foreach($prodiList as $p): ?>
          <option value="<?= (int)$p['id_prodi'] ?>" <?= (!empty($_GET['id_prodi']) && $_GET['id_prodi']==$p['id_prodi'])?'selected':'' ?>>
            <?= htmlspecialchars($p['nama_prodi']) ?>
          </option>
        <?php endforeach; ?>
      </select>

      <select name="id_ruangan">
        <option value="0">Semua Ruangan</option>
        <?php foreach($ruangList as $r): ?>
          <option value="<?= (int)$r['id_ruangan'] ?>" <?= (!empty($_GET['id_ruangan']) && $_GET['id_ruangan']==$r['id_ruangan'])?'selected':'' ?>>
            <!-- ✅ DIPERBAIKI: nama_ruangan → kode_ruangan -->
            <?= htmlspecialchars($r['kode_ruangan'].' — '.($r['nama_gedung'] ?? '')) ?>
          </option>
        <?php endforeach; ?>
      </select>

      <select name="id_hari" id="id_hari">
        <option value="0">Semua Hari</option>
        <?php foreach($hariList as $h): ?>
          <option value="<?= (int)$h['id_hari'] ?>" <?= (!empty($_GET['id_hari']) && $_GET['id_hari']==$h['id_hari'])?'selected':'' ?>>
            <?= htmlspecialchars($h['nama_hari']) ?>
          </option>
        <?php endforeach; ?>
      </select>

      <select name="sumber">
        <option value="">Semua Sumber</option>
        <option value="tetap"      <?= (($_GET['sumber'] ?? '')==='tetap')?'selected':'' ?>>Tetap</option>
        <option value="pengganti"  <?= (($_GET['sumber'] ?? '')==='pengganti')?'selected':'' ?>>Pengganti</option>
      </select>

      <!-- Tanggal acuan minggu: default HARI INI -->
      <input type="date" name="tanggal" id="tanggal"
             value="<?= htmlspecialchars($_GET['tanggal'] ?? date('Y-m-d')) ?>">

      <!-- Kolom pencarian -->
      <input type="text" name="q" placeholder="Cari MK / kelas / dosen / ruangan..."
             value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" style="grid-column:1 / span 4">

      <button class="btn" type="submit">Filter</button>
      <a class="btn btn-light" href="index.php?route=jadwal">Reset</a>
    </form>

    <script>
      // Sinkronkan dropdown Hari saat tanggal diubah (jika belum dipilih)
      document.getElementById('tanggal').addEventListener('change', function(){
        const selHari = document.getElementById('id_hari');
        if (selHari.value === "0" || selHari.value === "" ) {
          const d = new Date(this.value);
          const map = {1:1,2:2,3:3,4:4,5:5,6:6,0:1}; // Minggu → Senin
          selHari.value = map[d.getDay()] ?? 1;
        }
      });
    </script>
  </div>

  <!-- WEEKLY GRID (Senin–Sabtu pada minggu tanggal yang dipilih) -->
  <div class="card" style="margin-top:16px;">
    <?php
      // ===== Tanggal acuan minggu =====
      $anchorDate = $_GET['tanggal'] ?? date('Y-m-d');
      $dow = (int)date('N', strtotime($anchorDate)); // 1..7
      $mondayTs = strtotime($anchorDate . ' -' . (($dow>=1 && $dow<=7)?($dow-1):0) . ' day'); // Senin minggu itu

      // Siapkan label Senin–Sabtu minggu tsb
      $days = [];
      $idToName = [];
      foreach($hariList as $h){ $idToName[(int)$h['id_hari']] = $h['nama_hari']; }
      for ($i=0; $i<6; $i++) { // Senin..Sabtu
        $ts = strtotime("+$i day", $mondayTs);
        $days[] = [
          'id_hari' => $i+1,
          'nama'    => $idToName[$i+1] ?? 'Hari',
          'date'    => date('Y-m-d', $ts),
          'label'   => date('d M', $ts),
        ];
      }

      // ===== Susun map data mingguan: [id_hari][id_slot][id_ruangan] =====
      $weekMap = [];
      foreach ($days as $d) {
        $weekMap[$d['id_hari']] = [];
        if (!empty($slotList)) {
          foreach ($slotList as $s) {
            $weekMap[$d['id_hari']][$s['id_slot']] = []; // per-slot per-ruangan
          }
        }
      }

      // Peta urutan slot agar robust jika id_slot tidak 1..N
      $slotOrder = [];
      if (!empty($slotList)) {
        foreach ($slotList as $s) $slotOrder[] = $s['id_slot'];
      }
      $slotIndex = [];
      foreach ($slotOrder as $idx => $idSlotVal) $slotIndex[$idSlotVal] = $idx;

      // Isi map dengan memperhitungkan jumlah_sks (1 SKS = 1 slot)
      if (!empty($list)) {
        foreach ($list as $row) {
          $idh = (int)$row['id_hari'];
          $startSlotId = (int)$row['id_slot'];
          $idr = (int)$row['id_ruangan'];

          if (!isset($weekMap[$idh]) || !isset($slotIndex[$startSlotId])) continue;

          $dur = max(1, (int)$row['jumlah_sks']); // ubah jika 1 SKS ≠ 1 slot

          $startIdx = $slotIndex[$startSlotId];
          for ($k = 0; $k < $dur; $k++) {
            $targetIdx = $startIdx + $k;
            if (!isset($slotOrder[$targetIdx])) break; // melewati slot terakhir

            $targetSlotId = $slotOrder[$targetIdx];
            if (!isset($weekMap[$idh][$targetSlotId])) continue;

            // Isi jika kosong
            if (empty($weekMap[$idh][$targetSlotId][$idr])) {
              $weekMap[$idh][$targetSlotId][$idr] = $row;
            }
          }
        }
      }

      // util per ruangan per hari
      function utilForDay($ruangList, $slotList, $dayMap) {
        $util = [];
        $total = is_array($slotList) ? count($slotList) : 0;
        foreach ($ruangList as $ru) {
          $used = 0;
          if ($total > 0) {
            foreach ($slotList as $s) {
              $idSlot = $s['id_slot'];
              if (!empty($dayMap[$idSlot][$ru['id_ruangan']])) $used++;
            }
          }
          $util[$ru['id_ruangan']] = ($total>0) ? round(100*$used/$total,1) : 0;
        }
        return $util;
      }

      // Tab default = hari ini (atau pilihan user)
      $todayId = (int)date('N'); $defaultTab = ($todayId>=1 && $todayId<=6) ? $todayId : 1;
      $requestedHari = (int)($_GET['id_hari'] ?? 0);
      if ($requestedHari>=1 && $requestedHari<=6) $defaultTab = $requestedHari;
    ?>

    <h3 style="margin:0 0 8px 0">
      Okupansi Mingguan — <span class="kw"><?= htmlspecialchars(date('d M Y', $mondayTs)) ?></span>
      <span class="small">s/d <?= htmlspecialchars(date('d M Y', strtotime('+5 day', $mondayTs))) ?></span>
    </h3>
    <div class="occ-legend">
      <span><span class="dot dot-blue"></span>Jadwal Tetap</span>
      <span><span class="dot dot-green"></span>Kuliah Pengganti</span>
      <span><span class="dot dot-free"></span>Tersedia</span>
    </div>

    <!-- Tabs Hari -->
    <div class="tabs" id="dayTabs">
      <?php foreach ($days as $d): ?>
        <button class="tab-btn <?= ($d['id_hari']==$defaultTab?'active':'') ?>" data-day="<?= (int)$d['id_hari'] ?>">
          <?= htmlspecialchars($d['nama']) ?>
          <span class="tab-sub"><?= htmlspecialchars($d['label']) ?></span>
        </button>
      <?php endforeach; ?>
    </div>

    <?php if (empty($slotList) || empty($ruangList)): ?>
      <p class="small">Data master slot waktu atau ruangan belum tersedia.</p>
    <?php else: ?>

      <?php foreach ($days as $d):
        $day = $d['id_hari'];
        $date = $d['date']; // ✅ Ambil tanggal hari ini
        $util = utilForDay($ruangList, $slotList, $weekMap[$day]);

        // Siapkan pembagian slot: Page 1 (1–6), Page 2 (7–13)
        $slotsPage1 = array_slice($slotList, 0, 6);
        $slotsPage2 = array_slice($slotList, 6, 7); // sampai 13 (jika ada)
        $hasPage2   = count($slotsPage2) > 0;

        // Helper render tabel: header = sesi, baris = ruangan
        $renderTable = function($slotsSubset) use ($ruangList, $weekMap, $day, $date, $util) { // ✅ Tambahkan $date
          ?>
          <table class="occ-table">
            <thead>
              <tr>
                <th class="occ-sticky-col">Ruangan</th>
                <?php foreach ($slotsSubset as $s): ?>
                  <th>
                    <div class="kw">Sesi <?= (int)$s['id_slot'] ?></div>
                    <div class="small"><?= htmlspecialchars($s['jam_mulai']) ?>–<?= htmlspecialchars($s['jam_selesai']) ?></div>
                  </th>
                <?php endforeach; ?>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($ruangList as $ru): ?>
                <tr>
                  <th class="occ-sticky-col">
                    <!-- ✅ DIPERBAIKI: nama_ruangan → kode_ruangan -->
                    <div class="kw"><?= htmlspecialchars($ru['kode_ruangan']) ?></div>
                    <div class="small"><?= htmlspecialchars($ru['nama_gedung'] ?? '') ?></div>
                    <span class="util"><?= $util[$ru['id_ruangan']] ?? 0 ?>% terpakai</span>
                  </th>
                  <?php foreach ($slotsSubset as $s):
                    $cell = $weekMap[$day][$s['id_slot']][$ru['id_ruangan']] ?? null;
                  ?>
                    <td>
                      <?php if ($cell): ?>
                        <div class="occ-cell-title">
                          <?= htmlspecialchars($cell['nama_mk'] ?? '—') ?>
                          <span class="occ-badge <?= $cell['sumber']==='pengganti' ? 'pengganti':'tetap' ?>">
                            <?= $cell['sumber']==='pengganti' ? 'Pengganti' : 'Tetap' ?>
                          </span>
                        </div>
                        <div class="occ-cell-sub">
                          <?= htmlspecialchars($cell['kode_kelas'] ?? '-') ?> ·
                          <?= htmlspecialchars($cell['nama_dosen'] ?? '-') ?> ·
                          SKS <?= (int)$cell['jumlah_sks'] ?>
                        </div>
                        <!-- ✅ TOMBOL EDIT & HAPUS -->
                        <div style="margin-top:6px; display:flex; gap:4px; font-size:0.75rem;">
                          <a href="index.php?route=jadwal_edit&id=<?= (int)$cell['id_jadwal'] ?>" 
                             style="padding:3px 6px; background:#2563eb; color:#fff; text-decoration:none; border-radius:4px; flex:1; text-align:center;">Edit</a>
                          <a href="index.php?route=jadwal_delete&id=<?= (int)$cell['id_jadwal'] ?>" 
                             onclick="return confirm('Yakin hapus jadwal ini?')"
                             style="padding:3px 6px; background:#dc2626; color:#fff; text-decoration:none; border-radius:4px; flex:1; text-align:center;">Hapus</a>
                        </div>
                      <?php else: ?>
                        <!-- ✅ DIPERBAIKI: Ganti "Tersedia" jadi tombol booking -->
                        <a href="index.php?route=booking_add&ruangan=<?= (int)$ru['id_ruangan'] ?>&hari=<?= (int)$day ?>&slot=<?= (int)$s['id_slot'] ?>&tanggal=<?= htmlspecialchars($date) ?>"
                           style="display:block;padding:8px;background:#d1fae5;color:#065f46;text-decoration:none;border-radius:8px;font-size:0.85rem;text-align:center;">
                          📅 Tersedia
                        </a>
                      <?php endif; ?>
                    </td>
                  <?php endforeach; ?>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
          <?php
        };
      ?>
        <div class="day-panel <?= ($day==$defaultTab?'active':'') ?>" data-day-panel="<?= (int)$day ?>">
          <h4 style="margin:2px 0 10px 0">
            <?= htmlspecialchars($d['nama']) ?>,
            <span class="small"><?= htmlspecialchars($d['date']) ?></span>
          </h4>

          <!-- Pager -->
          <div class="pager" data-pager-for="<?= (int)$day ?>">
            <button type="button" class="btn-page prev"  data-step="-1">Prev</button>
            <button type="button" class="btn-page page-indicator active" data-page="1">1</button>
            <?php if ($hasPage2): ?>
              <button type="button" class="btn-page page-indicator" data-page="2">2</button>
            <?php endif; ?>
            <button type="button" class="btn-page next"  data-step="1">Next</button>
          </div>

          <div class="page-hint" data-hint-for="<?= (int)$day ?>">
            Menampilkan <strong>Page 1</strong>
            (Sesi <?= count($slotsPage1) ? (int)$slotsPage1[0]['id_slot'] : '-' ?>–<?= count($slotsPage1) ? (int)$slotsPage1[count($slotsPage1)-1]['id_slot'] : '-' ?>)
            <?php if ($hasPage2): ?>
              ; Page 2 (Sesi <?= (int)$slotsPage2[0]['id_slot'] ?>–<?= (int)$slotsPage2[count($slotsPage2)-1]['id_slot'] ?>)
            <?php endif; ?>
          </div>

          <!-- Halaman 1 -->
          <div class="page page-1 active" data-day="<?= (int)$day ?>">
            <?php $renderTable($slotsPage1); ?>
          </div>

          <!-- Halaman 2 (jika ada) -->
          <?php if ($hasPage2): ?>
            <div class="page page-2" data-day="<?= (int)$day ?>">
              <?php $renderTable($slotsPage2); ?>
            </div>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>

    <?php endif; ?>

    <p class="small" style="margin-top:10px;">
      Tampilan memuat <b>Senin–Sabtu</b> pada minggu yang mengandung <b>tanggal acuan</b> (default: hari ini).
      Gunakan filter untuk mengganti <b>Prodi</b>, <b>Ruangan</b>, <b>Hari (tab)</b>, <b>Sumber</b>, <b>Tanggal</b>, atau <b>kata kunci</b>.
    </p>
    <p style="margin-top:16px;"><a href="index.php">← Kembali ke Dashboard</a></p>
  </div>
</div>

<script>
  // Tab switcher per-hari
  (function(){
    const tabs  = document.querySelectorAll('.tab-btn');
    const panes = document.querySelectorAll('.day-panel');
    tabs.forEach(btn=>{
      btn.addEventListener('click', ()=>{
        const day = btn.getAttribute('data-day');
        tabs.forEach(b=>b.classList.remove('active'));
        panes.forEach(p=>p.classList.remove('active'));
        btn.classList.add('active');
        const panel = document.querySelector(`.day-panel[data-day-panel="${day}"]`);
        if (panel) panel.classList.add('active');

        // sinkronkan dropdown Hari agar konsisten (opsional)
        const sel = document.getElementById('id_hari');
        if (sel) sel.value = String(day);
      });
    });
  })();

  // Pager 2 halaman sesi per day-panel
  (function(){
    document.querySelectorAll('.day-panel').forEach(panel=>{
      const pager = panel.querySelector('.pager');
      if (!pager) return;

      let currentPage = 1;
      const day = pager.getAttribute('data-pager-for');
      const btnPrev = pager.querySelector('.prev');
      const btnNext = pager.querySelector('.next');
      const indicators = pager.querySelectorAll('.page-indicator');
      const page1 = panel.querySelector('.page-1');
      const page2 = panel.querySelector('.page-2');
      const hint = panel.querySelector('.page-hint');

      function showPage(n){
        currentPage = n;
        if (page1) page1.classList.toggle('active', n === 1);
        if (page2) page2.classList.toggle('active', n === 2);
        indicators.forEach(b=> b.classList.toggle('active', b.getAttribute('data-page') == String(n)));
        if (hint) {
          hint.innerHTML = hint.innerHTML.replace(/Page\s[12]/g, 'Page ' + n);
        }
      }

      indicators.forEach(b=>{
        b.addEventListener('click', ()=> showPage(parseInt(b.getAttribute('data-page'), 10)));
      });

      btnPrev && btnPrev.addEventListener('click', ()=>{
        const hasPage2 = !!page2;
        if (!hasPage2) return;
        showPage(currentPage === 1 ? 2 : 1);
      });
      btnNext && btnNext.addEventListener('click', ()=>{
        const hasPage2 = !!page2;
        if (!hasPage2) return;
        showPage(currentPage === 1 ? 2 : 1);
      });
    });
  })();
</script>

<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>