<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
.topbar{background:#14b8a6;color:#fff;padding:14px 28px;font-weight:600;}
.container{max-width:1100px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);}
a.btn,button.btn{padding:8px 12px;border-radius:10px;text-decoration:none;font-weight:600;border:none;cursor:pointer;display:inline-block}
.btn-add{background:#2563eb;color:#fff;}
.btn-ok{background:#10b981;color:#fff;}
.btn-no{background:#ef4444;color:#fff;}
.small{color:#64748b;font-size:.85rem}
table{width:100%;border-collapse:collapse;margin-top:16px}
th,td{padding:10px;border-bottom:1px solid #e2e8f0;text-align:left}
th{background:#f1f5f9}
.badge{background:#e2e8f0;border-radius:999px;padding:4px 10px;font-size:.8rem}
.status{padding:4px 10px;border-radius:999px;font-size:.8rem;color:#fff}
.st-aju{background:#6366f1}.st-set{background:#10b981}.st-tol{background:#ef4444}.st-bat{background:#475569}
</style>

<div class="topbar">Booking Ruangan (Dosen)</div>
<div class="container">
  <a href="index.php?route=booking_add" class="btn btn-add">+ Ajukan Booking</a>

  <?php if (isset($_SESSION['flash'])): ?>
    <div style="padding:12px;background:#d1fae5;color:#065f46;border-radius:8px;margin:16px 0;">
      <?= htmlspecialchars($_SESSION['flash']) ?>
    </div>
    <?php unset($_SESSION['flash']); ?>
  <?php endif; ?>

  <table>
    <thead>
      <tr>
        <th>ID</th>
        <th>Tanggal</th>
        <th>Ruangan</th>
        <th>Hari & Slot</th>
        <th>Dosen</th>
        <th>MK & Kelas</th>
        <th>Keperluan</th>
        <th>Status</th>
        <?php if (!empty($_SESSION['user']) && $_SESSION['user']['role']==='admin'): ?>
          <th style="width:220px;">Aksi</th>
        <?php endif; ?>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($list)): ?>
        <tr>
          <td colspan="<?= (!empty($_SESSION['user']) && $_SESSION['user']['role']==='admin') ? 9 : 8 ?>" style="text-align:center;color:#64748b;padding:18px;">
            Belum ada booking.
          </td>
        </tr>
      <?php else: foreach($list as $r): ?>
        <tr>
          <td><span class="badge"><?= (int)$r['id_booking'] ?></span></td>
          <td><?= htmlspecialchars($r['tanggal']) ?></td>
          <td>
            <?= htmlspecialchars($r['kode_ruangan']) ?> 
            <span class="small">— <?= htmlspecialchars($r['nama_gedung']) ?></span>
          </td>
          <td>
            <?= htmlspecialchars($r['nama_hari']) ?><br>
            <span class="small"><?= substr($r['jam_mulai'],0,5) ?>–<?= substr($r['jam_selesai'],0,5) ?></span>
          </td>
          <td><?= htmlspecialchars($r['nama_dosen']) ?></td>
          <td>
            <b><?= htmlspecialchars($r['mata_kuliah'] ?: '-') ?></b><br>
            <span class="small"><?= htmlspecialchars($r['kelas'] ?: '-') ?></span>
          </td>
          <td><?= htmlspecialchars($r['keperluan'] ?? '-') ?></td>
          <td>
            <?php 
            $map = ['diajukan'=>'st-aju','disetujui'=>'st-set','ditolak'=>'st-tol','dibatalkan'=>'st-bat']; 
            $cls = $map[$r['status']] ?? 'st-aju'; 
            ?>
            <span class="status <?= $cls ?>"><?= htmlspecialchars($r['status']) ?></span>
          </td>

          <?php if (!empty($_SESSION['user']) && $_SESSION['user']['role']==='admin'): ?>
            <td>
              <?php if ($r['status']==='diajukan'): ?>
                <a class="btn btn-ok" href="index.php?route=booking_approve&id=<?= (int)$r['id_booking'] ?>" 
                   onclick="return confirm('Setujui booking ini?')">
                  Setujui
                </a>
                <a class="btn btn-no" href="index.php?route=booking_reject&id=<?= (int)$r['id_booking'] ?>" 
                   onclick="return confirm('Tolak booking ini?')">
                  Tolak
                </a>
              <?php else: ?>
                <span class="small">Tidak ada aksi</span>
              <?php endif; ?>
            </td>
          <?php endif; ?>
        </tr>
      <?php endforeach; endif; ?>
    </tbody>
  </table>

  <p style="margin-top:20px;"><a href="index.php">← Kembali ke Dashboard</a></p>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>