<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>

<?php
// ✅ Ambil data default dari controller (jika ada)
$defaultRuangan = $defaultRuangan ?? 0;
$defaultHari = $defaultHari ?? 0;
$defaultSlot = $defaultSlot ?? 0;
$defaultTanggal = $defaultTanggal ?? date('Y-m-d');
?>

<div style="max-width:900px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);">
  <h2 style="color:#1e3a8a;margin-top:0;">Ajukan Booking Ruangan</h2>
  
  <?php if (isset($_SESSION['flash'])): ?>
    <div style="padding:12px;background:#fee2e2;color:#991b1b;border-radius:8px;margin-bottom:16px;">
      <?= htmlspecialchars($_SESSION['flash']) ?>
    </div>
    <?php unset($_SESSION['flash']); ?>
  <?php endif; ?>

  <form method="post" action="index.php?route=booking_add" autocomplete="off" style="display:grid;grid-template-columns:1fr 1fr;gap:16px;">
    <div>
      <label>Dosen</label>
      <select name="id_dosen" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;" <?= (!empty($_SESSION['user']) && $_SESSION['user']['role']==='dosen')?'disabled':'' ?>>
        <?php foreach($dosenList as $d): 
          $selected = (!empty($_SESSION['user']['id_dosen']) && $_SESSION['user']['id_dosen']==$d['id_dosen'])?'selected':''; ?>
          <option value="<?= (int)$d['id_dosen'] ?>" <?= $selected ?>><?= htmlspecialchars($d['nama_lengkap']) ?></option>
        <?php endforeach; ?>
      </select>
      <?php if (!empty($_SESSION['user']) && $_SESSION['user']['role']==='dosen'): ?>
        <input type="hidden" name="id_dosen" value="<?= (int)($_SESSION['user']['id_dosen'] ?? 0) ?>">
      <?php endif; ?>
    </div>

    <div>
      <label>Tanggal</label>
      <input type="date" name="tanggal" value="<?= htmlspecialchars($defaultTanggal) ?>" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
    </div>

    <div>
      <label>Hari</label>
      <select name="id_hari" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Hari --</option>
        <?php foreach($hariList as $h): ?>
          <option value="<?= (int)$h['id_hari'] ?>" <?= ($defaultHari == $h['id_hari']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($h['nama_hari']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Slot Waktu</label>
      <select name="id_slot" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Slot --</option>
        <?php foreach($slotList as $s): ?>
          <option value="<?= (int)$s['id_slot'] ?>" <?= ($defaultSlot == $s['id_slot']) ? 'selected' : '' ?>>
            <?= substr($s['jam_mulai'],0,5) ?>–<?= substr($s['jam_selesai'],0,5) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Ruangan</label>
      <select name="id_ruangan" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Ruangan --</option>
        <?php foreach($ruangList as $r): ?>
          <option value="<?= (int)$r['id_ruangan'] ?>" <?= ($defaultRuangan == $r['id_ruangan']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($r['kode_ruangan']) ?> — <?= htmlspecialchars($r['nama_gedung']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Jumlah SKS</label>
      <select name="jumlah_sks" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="1" <?= (1 == 2) ? '' : 'selected' ?>>1</option>
        <option value="2" selected>2</option>
        <option value="3">3</option>
      </select>
    </div>

    <!-- ✅ MATA KULIAH MENJADI DROPDOWN -->
    <div>
      <label>Mata Kuliah</label>
      <select name="mata_kuliah" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Mata Kuliah --</option>
        <?php foreach($mkList as $mk): ?>
          <option value="<?= htmlspecialchars($mk['nama_mk']) ?>"><?= htmlspecialchars($mk['nama_mk']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <!-- ✅ KELAS MENJADI DROPDOWN -->
    <div>
      <label>Kelas</label>
      <select name="kelas" required style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;">
        <option value="">-- Pilih Kelas --</option>
        <?php foreach($kelasList as $k): ?>
          <option value="<?= htmlspecialchars($k['kode_kelas']) ?>" <?= ($defaultKelas == $k['kode_kelas']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($k['kode_kelas']) ?> — <?= htmlspecialchars($k['nama_prodi'] ?? '') ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div style="grid-column:1 / span 2">
      <label>Keperluan (opsional)</label>
      <textarea name="keperluan" rows="3" style="width:100%;padding:10px;border:1px solid #cbd5e1;border-radius:10px;"></textarea>
    </div>

    <div style="grid-column:1 / span 2">
      <button style="background:#2563eb;color:#fff;padding:10px 18px;border:none;border-radius:10px;cursor:pointer;">Ajukan Booking</button>
      <a href="index.php?route=booking" style="margin-left:10px;color:#475569;text-decoration:none;">Batal</a>
    </div>
  </form>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>