<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>

<style>
body {
  margin: 0;
  font-family: 'Poppins', sans-serif;
  background: linear-gradient(135deg, #2563eb, #1e40af);
  height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
}
.login-card {
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 8px 30px rgba(0,0,0,0.1);
  width: 400px;
  padding: 40px 30px;
  text-align: center;
}
.login-card h2 {
  color: #1e3a8a;
  margin-bottom: 10px;
}
.login-card p {
  color: #64748b;
  font-size: 0.9rem;
  margin-bottom: 25px;
}
form label {
  display: block;
  text-align: left;
  font-size: 0.85rem;
  color: #334155;
  margin-top: 10px;
}
form input {
  width: 100%;
  padding: 10px 12px;
  border: 1px solid #cbd5e1;
  border-radius: 10px;
  margin-top: 5px;
  font-size: 0.95rem;
}
form input:focus {
  border-color: #2563eb;
  outline: none;
  box-shadow: 0 0 0 3px rgba(37,99,235,0.2);
}
button {
  width: 100%;
  padding: 12px;
  border: none;
  background: #2563eb;
  color: white;
  font-weight: 600;
  border-radius: 10px;
  margin-top: 20px;
  cursor: pointer;
  transition: background 0.2s ease-in-out;
}
button:hover {
  background: #1d4ed8;
}
.error {
  background: #fee2e2;
  color: #991b1b;
  border: 1px solid #fecaca;
  border-radius: 8px;
  padding: 8px 10px;
  margin-top: 15px;
  font-size: 0.85rem;
}
.footer-note {
  margin-top: 20px;
  font-size: 0.8rem;
  color: #94a3b8;
}
</style>

<div class="login-card">
  <h2>Selamat Datang 👋</h2>
  <p>Silakan masuk ke sistem manajemen jadwal perkuliahan</p>
  <form method="post" action="index.php?route=login" autocomplete="off">
    <label>Username</label>
    <input type="text" name="username" placeholder="Masukkan username" required>

    <label>Password</label>
    <input type="password" name="password" placeholder="Masukkan password" required>

    <button type="submit">Masuk</button>

    <?php if (!empty($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
  </form>

  <div class="footer-note">
    &copy; <?= date('Y'); ?> Universitas Syedza Saintika
  </div>
</div>

<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>
