<?php
require_once __DIR__ . '/../../Config/Database.php';

class RuanganModel {
    /**
     * Ambil semua ruangan (dengan gedung)
     */
    public static function all() {
        $pdo = Database::getConnection();
        $sql = "SELECT r.*, g.nama_gedung 
                FROM ruangan r
                LEFT JOIN gedung g ON r.id_gedung = g.id_gedung
                ORDER BY r.kode_ruangan ASC";
        return $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Ambil semua ruangan (dengan gedung) — alias untuk kompatibilitas
     */
    public static function allWithGedung() {
        return self::all();
    }

    /**
     * Cari ruangan berdasarkan ID
     */
    public static function find($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("SELECT * FROM ruangan WHERE id_ruangan = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    /**
     * Tambah ruangan baru
     */
    public static function create($kode_ruangan, $id_gedung, $kapasitas, $keterangan = '', $lokasi = '') {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("INSERT INTO ruangan (kode_ruangan, id_gedung, kapasitas, keterangan, lokasi) VALUES (?, ?, ?, ?, ?)");
        return $stmt->execute([$kode_ruangan, $id_gedung, $kapasitas, $keterangan, $lokasi]);
    }

    /**
     * Update ruangan
     */
    public static function update($id, $kode_ruangan, $id_gedung, $kapasitas, $keterangan = '', $lokasi = '') {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("UPDATE ruangan SET kode_ruangan = ?, id_gedung = ?, kapasitas = ?, keterangan = ?, lokasi = ? WHERE id_ruangan = ?");
        return $stmt->execute([$kode_ruangan, $id_gedung, $kapasitas, $keterangan, $lokasi, $id]);
    }

    /**
     * Hapus ruangan
     */
    public static function delete($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("DELETE FROM ruangan WHERE id_ruangan = ?");
        return $stmt->execute([$id]);
    }
}