<?php
require_once __DIR__ . '/../../Config/Database.php';

class PengajuanModel {
    public static function allWithJoins($idProdiFilter = 0) {
        $pdo = Database::getConnection();
        $sql = "SELECT pj.*, 
                       p.nama_prodi, mk.nama_mk, k.kode_kelas, d.nama_lengkap AS nama_dosen,
                       r.kode_ruangan, h.nama_hari, sw.jam_mulai, sw.jam_selesai
                FROM pengajuan_jadwal pj
                JOIN prodi p        ON p.id_prodi = pj.id_prodi
                JOIN mata_kuliah mk ON mk.id_mk = pj.id_mk
                JOIN kelas k        ON k.id_kelas = pj.id_kelas
                JOIN dosen d        ON d.id_dosen = pj.id_dosen
                JOIN ruangan r      ON r.id_ruangan = pj.id_ruangan
                JOIN hari h         ON h.id_hari = pj.id_hari
                JOIN slot_waktu sw  ON sw.id_slot = pj.id_slot";
        $args = [];
        if ($idProdiFilter > 0) {
            $sql .= " WHERE pj.id_prodi = ?";
            $args[] = $idProdiFilter;
        }
        $sql .= " ORDER BY pj.diajukan_pada DESC";
        $st = Database::getConnection()->prepare($sql);
        $st->execute($args);
        return $st->fetchAll();
    }

    public static function create($p) {
        $pdo = Database::getConnection();
        $sql = "INSERT INTO pengajuan_jadwal
                (id_prodi,id_mk,id_kelas,id_dosen,id_ruangan,id_hari,id_slot,jumlah_sks,
                 tanggal_mulai,tanggal_selesai,keterangan,status,diajukan_pada,diajukan_oleh)
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)";
        $st = $pdo->prepare($sql);
        return $st->execute([
            $p['id_prodi'],$p['id_mk'],$p['id_kelas'],$p['id_dosen'],$p['id_ruangan'],
            $p['id_hari'],$p['id_slot'],$p['jumlah_sks'],$p['tanggal_mulai'],$p['tanggal_selesai'],
            $p['keterangan'],'diajukan',$p['diajukan_oleh']
        ]);
    }

    public static function find($id) {
        $st = Database::getConnection()->prepare("SELECT * FROM pengajuan_jadwal WHERE id_pengajuan = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    public static function setStatus($id, $status) {
        $pdo = Database::getConnection();
        if ($status === 'disetujui') {
            $st = $pdo->prepare("UPDATE pengajuan_jadwal SET status='disetujui', disetujui_pada = NOW() WHERE id_pengajuan = ?");
        } else {
            $st = $pdo->prepare("UPDATE pengajuan_jadwal SET status='ditolak', disetujui_pada = NULL WHERE id_pengajuan = ?");
        }
        return $st->execute([$id]);
    }

    // Cek bentrok: overlap tanggal + ruangan/hari/slot sama (cek pengajuan disetujui & jadwal)
    public static function isConflict($p) {
        $pdo = Database::getConnection();

        $sql1 = "SELECT 1 FROM pengajuan_jadwal
                 WHERE status='disetujui'
                   AND id_ruangan=? AND id_hari=? AND id_slot=?
                   AND tanggal_mulai <= ? AND tanggal_selesai >= ?
                 LIMIT 1";
        $st1 = $pdo->prepare($sql1);
        $st1->execute([$p['id_ruangan'],$p['id_hari'],$p['id_slot'],$p['tanggal_selesai'],$p['tanggal_mulai']]);
        if ($st1->fetchColumn()) return true;

        $sql2 = "SELECT 1 FROM jadwal
                 WHERE id_ruangan=? AND id_hari=? AND id_slot=?
                   AND tanggal_mulai <= ? AND tanggal_selesai >= ?
                 LIMIT 1";
        $st2 = $pdo->prepare($sql2);
        $st2->execute([$p['id_ruangan'],$p['id_hari'],$p['id_slot'],$p['tanggal_selesai'],$p['tanggal_mulai']]);
        return (bool)$st2->fetchColumn();
    }
}
