<?php
require_once __DIR__ . '/../../Config/Database.php';

class MataKuliahModel {
    // ✅ TAMBAHKAN METHOD INI
    public static function all() {
        $pdo = Database::getConnection();
        $sql = "SELECT * FROM mata_kuliah ORDER BY nama_mk ASC";
        return $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    // === METHOD YANG SUDAH ADA (JANGAN DIUBAH) ===
    public static function allWithProdi() {
        $pdo = Database::getConnection();
        $sql = "SELECT mk.*, p.nama_prodi
                FROM mata_kuliah mk
                JOIN prodi p ON p.id_prodi = mk.id_prodi
                ORDER BY mk.id_mk ASC";
        return $pdo->query($sql)->fetchAll();
    }

    public static function filter($q, $id_prodi) {
        $pdo = Database::getConnection();
        $conds = []; $args = [];
        $sql = "SELECT mk.*, p.nama_prodi
                FROM mata_kuliah mk
                JOIN prodi p ON p.id_prodi = mk.id_prodi";

        if ($q !== '') { $conds[] = "mk.nama_mk LIKE ?"; $args[] = '%'.$q.'%'; }
        if ($id_prodi > 0) { $conds[] = "mk.id_prodi = ?"; $args[] = $id_prodi; }

        if ($conds) $sql .= " WHERE ".implode(" AND ", $conds);
        $sql .= " ORDER BY mk.id_mk ASC";

        $st = $pdo->prepare($sql);
        $st->execute($args);
        return $st->fetchAll();
    }

    public static function find($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("SELECT * FROM mata_kuliah WHERE id_mk = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    public static function create($nama, $id_prodi, $sks) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("INSERT INTO mata_kuliah (nama_mk, id_prodi, sks) VALUES (?, ?, ?)");
        return $st->execute([$nama, $id_prodi, $sks]);
    }

    public static function update($id, $nama, $id_prodi, $sks) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("UPDATE mata_kuliah SET nama_mk = ?, id_prodi = ?, sks = ? WHERE id_mk = ?");
        return $st->execute([$nama, $id_prodi, $sks, $id]);
    }

    public static function delete($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("DELETE FROM mata_kuliah WHERE id_mk = ?");
        return $st->execute([$id]);
    }

    public static function existsByNameProdi($nama, $id_prodi, $excludeId = null) {
        $pdo = Database::getConnection();
        if ($excludeId) {
            $st = $pdo->prepare("SELECT 1 FROM mata_kuliah WHERE nama_mk = ? AND id_prodi = ? AND id_mk != ? LIMIT 1");
            $st->execute([$nama, $id_prodi, $excludeId]);
        } else {
            $st = $pdo->prepare("SELECT 1 FROM mata_kuliah WHERE nama_mk = ? AND id_prodi = ? LIMIT 1");
            $st->execute([$nama, $id_prodi]);
        }
        return (bool)$st->fetchColumn();
    }
}