<?php
require_once __DIR__ . '/../../Config/Database.php';

class KelasModel {
    /**
     * Ambil semua data kelas + nama prodi
     */
    public static function all() {
        $pdo = Database::getConnection();
        $sql = "SELECT 
                    k.id_kelas, 
                    k.kode_kelas, 
                    k.id_prodi, 
                    p.nama_prodi 
                FROM kelas k 
                LEFT JOIN prodi p ON k.id_prodi = p.id_prodi 
                ORDER BY k.kode_kelas ASC";
        return $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Cari kelas berdasarkan ID
     */
    public static function find($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("SELECT * FROM kelas WHERE id_kelas = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    /**
     * Tambah kelas baru
     */
    public static function create($kode_kelas, $id_prodi) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("INSERT INTO kelas (kode_kelas, id_prodi) VALUES (?, ?)");
        return $stmt->execute([$kode_kelas, $id_prodi]);
    }

    /**
     * Update data kelas
     */
    public static function update($id, $kode_kelas, $id_prodi) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("UPDATE kelas SET kode_kelas = ?, id_prodi = ? WHERE id_kelas = ?");
        return $stmt->execute([$kode_kelas, $id_prodi, $id]);
    }

    /**
     * Hapus kelas
     */
    public static function delete($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("DELETE FROM kelas WHERE id_kelas = ?");
        return $stmt->execute([$id]);
    }
}