<?php
require_once __DIR__ . '/../../Config/Database.php';

class JadwalModel {
    // == METHOD YANG SUDAH ADA (JANGAN DIHAPUS) ==
    public static function createFromPengajuan($pj) {
        $pdo = Database::getConnection();
        $sql = "INSERT INTO jadwal
                (id_hari,id_slot,id_ruangan,id_mk,id_kelas,id_dosen,
                 tanggal_mulai,tanggal_selesai,jumlah_sks,sumber,id_pengajuan_asal,id_booking_asal)
                VALUES (?,?,?,?,?,?,?,?,?,'tetap',?,NULL)";
        $st = $pdo->prepare($sql);
        return $st->execute([
            $pj['id_hari'],$pj['id_slot'],$pj['id_ruangan'],$pj['id_mk'],$pj['id_kelas'],$pj['id_dosen'],
            $pj['tanggal_mulai'],$pj['tanggal_selesai'],$pj['jumlah_sks'],$pj['id_pengajuan']
        ]);
    }

    public static function createFromBooking($bk) {
        $pdo = Database::getConnection();
        $sql = "INSERT INTO jadwal
                (id_hari,id_slot,id_ruangan,id_mk,id_kelas,id_dosen,
                 tanggal_mulai,tanggal_selesai,jumlah_sks,sumber,id_pengajuan_asal,id_booking_asal)
                VALUES (?,?,?,?,?,?,?,? ,?,'pengganti',NULL,?)";
        $st = $pdo->prepare($sql);
        return $st->execute([
            $bk['id_hari'],$bk['id_slot'],$bk['id_ruangan'],
            NULL, NULL, $bk['id_dosen'],
            $bk['tanggal'],$bk['tanggal'],$bk['jumlah_sks'],
            $bk['id_booking']
        ]);
    }

    // == ✅ METHOD TAMBAHAN ==

    public static function find($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("SELECT * FROM jadwal WHERE id_jadwal = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function update($id, $data) {
        $pdo = Database::getConnection();
        $fields = [];
        $values = [];
        foreach ($data as $key => $value) {
            $fields[] = "`$key` = ?";
            $values[] = $value;
        }
        $values[] = $id;
        $sql = "UPDATE jadwal SET " . implode(', ', $fields) . " WHERE id_jadwal = ?";
        $stmt = $pdo->prepare($sql);
        return $stmt->execute($values);
    }

    public static function delete($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("DELETE FROM jadwal WHERE id_jadwal = ?");
        return $stmt->execute([$id]);
    }

    public static function all() {
        $pdo = Database::getConnection();
        $sql = "
            SELECT 
                j.*,
                mk.nama_mk,
                k.kode_kelas,
                d.nama_lengkap AS nama_dosen,
                r.kode_ruangan,  -- ✅ INI SUDAH BENAR: GUNAKAN kode_ruangan
                g.nama_gedung,
                h.nama_hari,
                sw.jam_mulai,
                sw.jam_selesai
            FROM jadwal j
            LEFT JOIN mata_kuliah mk ON j.id_mk = mk.id_mk
            LEFT JOIN kelas k ON j.id_kelas = k.id_kelas
            LEFT JOIN dosen d ON j.id_dosen = d.id_dosen
            LEFT JOIN ruangan r ON j.id_ruangan = r.id_ruangan
            LEFT JOIN gedung g ON r.id_gedung = g.id_gedung
            LEFT JOIN hari h ON j.id_hari = h.id_hari
            LEFT JOIN slot_waktu sw ON j.id_slot = sw.id_slot
            ORDER BY j.id_hari, j.id_slot, r.kode_ruangan
        ";
        return $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }
}