<?php
require_once __DIR__ . '/../../Config/Database.php';

class HariModel {
    public static function all() {
        $pdo = Database::getConnection();
        $result = $pdo->query("SELECT * FROM hari ORDER BY id_hari ASC");
        return $result ? $result->fetchAll(PDO::FETCH_ASSOC) : [];
    }

    public static function find($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("SELECT * FROM hari WHERE id_hari = ?");
        $st->execute([$id]);
        return $st->fetch(PDO::FETCH_ASSOC);
    }

    public static function create($nama) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("INSERT INTO hari (nama_hari) VALUES (?)");
        return $st->execute([$nama]);
    }

    public static function update($id, $nama) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("UPDATE hari SET nama_hari = ? WHERE id_hari = ?");
        return $st->execute([$nama, $id]);
    }

    public static function delete($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("DELETE FROM hari WHERE id_hari = ?");
        return $st->execute([$id]);
    }
}