<?php
require_once __DIR__ . '/../../Config/Database.php';

class GedungModel {
    public static function all() {
        $pdo = Database::getConnection();
        return $pdo->query("SELECT * FROM gedung ORDER BY nama_gedung ASC")->fetchAll(PDO::FETCH_ASSOC);
    }

    public static function find($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("SELECT * FROM gedung WHERE id_gedung = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function create($nama_gedung) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("INSERT INTO gedung (nama_gedung) VALUES (?)");
        return $stmt->execute([$nama_gedung]);
    }

    public static function update($id, $nama_gedung) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("UPDATE gedung SET nama_gedung = ? WHERE id_gedung = ?");
        return $stmt->execute([$nama_gedung, $id]);
    }

    public static function delete($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("DELETE FROM gedung WHERE id_gedung = ?");
        return $stmt->execute([$id]);
    }
}