<?php
require_once __DIR__ . '/../../Config/Database.php';

class BookingModel {

    public static function allWithJoins($idDosenFilter = 0) {
        $pdo = Database::getConnection();
        $sql = "SELECT b.*, d.nama_lengkap AS nama_dosen, r.kode_ruangan, g.nama_gedung, h.nama_hari,
                       sw.jam_mulai, sw.jam_selesai
                FROM booking_ruangan b
                JOIN dosen d       ON d.id_dosen = b.id_dosen
                JOIN ruangan r     ON r.id_ruangan = b.id_ruangan
                JOIN gedung g      ON g.id_gedung = r.id_gedung
                JOIN hari h        ON h.id_hari = b.id_hari
                JOIN slot_waktu sw ON sw.id_slot = b.id_slot";

        $args = [];
        if ($idDosenFilter > 0) {
            $sql .= " WHERE b.id_dosen = ?";
            $args[] = $idDosenFilter;
        }

        $sql .= " ORDER BY b.diajukan_pada DESC";

        $st = $pdo->prepare($sql);
        $st->execute($args);
        return $st->fetchAll();
    }

    public static function find($id) {
        $st = Database::getConnection()->prepare("SELECT * FROM booking_ruangan WHERE id_booking = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    public static function create($p) {
        $pdo = Database::getConnection();
        $sql = "INSERT INTO booking_ruangan
                (id_dosen,id_ruangan,id_hari,id_slot,jumlah_sks,tanggal,mata_kuliah,kelas,keperluan,status,diajukan_pada)
                VALUES (?,?,?,?,?,?,?,?,?,'diajukan',NOW())";

        $st = $pdo->prepare($sql);
        return $st->execute([
            $p['id_dosen'],$p['id_ruangan'],$p['id_hari'],$p['id_slot'],$p['jumlah_sks'],
            $p['tanggal'],$p['mata_kuliah'],$p['kelas'],$p['keperluan']
        ]);
    }

    public static function setStatus($id, $status) {
        $pdo = Database::getConnection();

        if ($status === 'disetujui') {
            $sql = "UPDATE booking_ruangan SET status='disetujui', disetujui_pada = NOW() WHERE id_booking = ?";
        } else if ($status === 'ditolak') {
            $sql = "UPDATE booking_ruangan SET status='ditolak', disetujui_pada = NULL WHERE id_booking = ?";
        } else {
            $sql = "UPDATE booking_ruangan SET status='dibatalkan' WHERE id_booking = ?";
        }

        $st = $pdo->prepare($sql);
        return $st->execute([$id]);
    }

    /**
     * Cek apakah bentrok dengan ruangan, hari, slot & tanggal yang sama.
     * $excludeId = ID booking yang diabaikan saat approve.
     */
    public static function isConflict($p, $excludeId = 0) {
        $pdo = Database::getConnection();

        $tanggal    = $p['tanggal'];
        $id_ruangan = $p['id_ruangan'];
        $id_hari    = $p['id_hari'];
        $id_slot    = $p['id_slot'];

        // 1. Cek booking lain (selain dirinya sendiri)
        $sql = "SELECT 1 FROM booking_ruangan 
                WHERE status IN ('diajukan','disetujui')
                  AND id_ruangan = ?
                  AND id_hari = ?
                  AND id_slot = ?
                  AND tanggal = ?
                  AND id_booking != ?";

        $st = $pdo->prepare($sql);
        $st->execute([$id_ruangan, $id_hari, $id_slot, $tanggal, $excludeId]);

        if ($st->fetchColumn()) {
            return true; // ada booking lain yang bentrok
        }

        // 2. Cek jadwal tetap
        $sql2 = "SELECT 1 FROM jadwal
                 WHERE id_ruangan = ?
                   AND id_hari = ?
                   AND id_slot = ?
                   AND ? BETWEEN tanggal_mulai AND tanggal_selesai";

        $st2 = $pdo->prepare($sql2);
        $st2->execute([$id_ruangan, $id_hari, $id_slot, $tanggal]);

        if ($st2->fetchColumn()) {
            return true; // ada jadwal tetap yang bentrok
        }

        return false;
    }
}
