<?php
require_once __DIR__ . '/../models/UserModel.php';
require_once __DIR__ . '/../models/ProdiModel.php';
require_once __DIR__ . '/../models/DosenModel.php';

class UserController {
    private function onlyAdmin() {
        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang boleh mengelola user.';
            header("Location: index.php"); exit;
        }
    }

    public function index() {
        $this->onlyAdmin();
        $list = UserModel::all();
        require BASE_PATH . '/app/views/user/index.php';
    }

    public function add() {
        $this->onlyAdmin();
        $prodi = ProdiModel::all();
        $dosen = DosenModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'username' => trim($_POST['username'] ?? ''),
                'password' => trim($_POST['password'] ?? ''),
                'nama_lengkap' => trim($_POST['nama_lengkap'] ?? ''),
                'email' => trim($_POST['email'] ?? ''),
                'role' => trim($_POST['role'] ?? 'dosen'),
                'id_prodi' => (int)($_POST['id_prodi'] ?? 0),
                'id_dosen' => (int)($_POST['id_dosen'] ?? 0),
                'aktif' => 1
            ];

            // Validasi minimal
            if ($data['username']==='' || $data['password']==='' || $data['nama_lengkap']==='' || $data['role']==='') {
                $_SESSION['flash'] = 'Lengkapi field wajib.'; header("Location: index.php?route=user_add"); exit;
            }
            if ($data['role']==='prodi' && $data['id_prodi']<=0) { $_SESSION['flash']='Role PRODI harus pilih Prodi.'; header("Location:index.php?route=user_add"); exit; }
            if ($data['role']==='dosen' && $data['id_dosen']<=0) { $_SESSION['flash']='Role DOSEN harus pilih Dosen.'; header("Location:index.php?route=user_add"); exit; }
            if (UserModel::existsUsernameOrEmail($data['username'], $data['email'])) {
                $_SESSION['flash'] = 'Username atau email sudah dipakai.'; header("Location: index.php?route=user_add"); exit;
            }

            $data['password_hash'] = password_hash($data['password'], PASSWORD_DEFAULT);
            unset($data['password']);

            UserModel::create($data);
            $_SESSION['flash'] = 'User berhasil dibuat ✅';
            header("Location: index.php?route=user"); exit;
        }

        require BASE_PATH . '/app/views/user/form_add.php';
    }

    public function edit() {
        $this->onlyAdmin();
        $id = (int)($_GET['id'] ?? 0);
        $row = UserModel::find($id);
        if (!$row) { $_SESSION['flash']='User tidak ditemukan.'; header("Location:index.php?route=user"); exit; }

        $prodi = ProdiModel::all();
        $dosen = DosenModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'id_user' => $id,
                'username' => trim($_POST['username'] ?? ''),
                'nama_lengkap' => trim($_POST['nama_lengkap'] ?? ''),
                'email' => trim($_POST['email'] ?? ''),
                'role' => trim($_POST['role'] ?? ''),
                'id_prodi' => (int)($_POST['id_prodi'] ?? 0),
                'id_dosen' => (int)($_POST['id_dosen'] ?? 0),
            ];
            $pwd = trim($_POST['password'] ?? '');

            if ($data['username']==='' || $data['nama_lengkap']==='' || $data['role']==='') {
                $_SESSION['flash'] = 'Lengkapi field wajib.'; header("Location: index.php?route=user_edit&id=".$id); exit;
            }
            if ($data['role']==='prodi' && $data['id_prodi']<=0) { $_SESSION['flash']='Role PRODI harus pilih Prodi.'; header("Location:index.php?route=user_edit&id=".$id); exit; }
            if ($data['role']==='dosen' && $data['id_dosen']<=0) { $_SESSION['flash']='Role DOSEN harus pilih Dosen.'; header("Location:index.php?route=user_edit&id=".$id); exit; }

            if ($pwd !== '') $data['password_hash'] = password_hash($pwd, PASSWORD_DEFAULT);

            UserModel::update($data);
            $_SESSION['flash'] = 'User diperbarui ✅';
            header("Location: index.php?route=user"); exit;
        }

        require BASE_PATH . '/app/views/user/form_edit.php';
    }

    public function delete() {
        $this->onlyAdmin();
        $id = (int)($_GET['id'] ?? 0);
        UserModel::delete($id);
        $_SESSION['flash'] = 'User dihapus.';
        header("Location: index.php?route=user"); exit;
    }

    public function toggle() {
        $this->onlyAdmin();
        $id = (int)($_GET['id'] ?? 0);
        UserModel::toggleActive($id);
        $_SESSION['flash'] = 'Status user diperbarui.';
        header("Location: index.php?route=user"); exit;
    }
}
