<?php

require_once __DIR__ . '/../models/RuanganModel.php';
require_once __DIR__ . '/../models/GedungModel.php';

class RuanganController {
    public function index() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $ruanganList = RuanganModel::all();

        $view = BASE_PATH . '/app/views/ruangan/index.php';
        if (!file_exists($view)) {
            die("❌ Error: File view tidak ditemukan: $view");
        }
        include $view;
    }

    public function add() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $kode_ruangan = trim($_POST['kode_ruangan']);
            $id_gedung = (int)$_POST['id_gedung'];
            $kapasitas = (int)$_POST['kapasitas'];
            $keterangan = $_POST['keterangan'] ?? '';
            $lokasi = $_POST['lokasi'] ?? '';

            if (empty($kode_ruangan)) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Kode Ruangan wajib diisi.'];
            } elseif ($id_gedung <= 0) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Gedung wajib dipilih.'];
            } elseif ($kapasitas <= 0 || !is_numeric($kapasitas)) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Kapasitas harus berupa angka dan lebih dari 0.'];
            } elseif (empty($lokasi)) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Lokasi wajib diisi.'];
            } else {
                if (RuanganModel::create($kode_ruangan, $id_gedung, $kapasitas, $keterangan, $lokasi)) {
                    $_SESSION['message'] = ['type' => 'success', 'text' => 'Ruangan berhasil ditambahkan.'];
                } else {
                    $_SESSION['message'] = ['type' => 'error', 'text' => 'Gagal menambahkan ruangan.'];
                }
            }
            header('Location: index.php?route=ruangan');
            exit;
        }

        $gedungList = GedungModel::all();

        $view = BASE_PATH . '/app/views/ruangan/form_add.php';
        if (!file_exists($view)) {
            die("❌ Error: File view tidak ditemukan: $view");
        }
        include $view;
    }

    public function edit() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        if ($id <= 0) {
            header('Location: index.php?route=ruangan');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $kode_ruangan = trim($_POST['kode_ruangan']);
            $id_gedung = (int)$_POST['id_gedung'];
            $kapasitas = (int)$_POST['kapasitas'];
            $keterangan = $_POST['keterangan'] ?? '';
            $lokasi = $_POST['lokasi'] ?? '';

            if (empty($kode_ruangan)) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Kode Ruangan wajib diisi.'];
            } elseif ($id_gedung <= 0) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Gedung wajib dipilih.'];
            } elseif ($kapasitas <= 0 || !is_numeric($kapasitas)) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Kapasitas harus berupa angka dan lebih dari 0.'];
            } elseif (empty($lokasi)) {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Lokasi wajib diisi.'];
            } else {
                if (RuanganModel::update($id, $kode_ruangan, $id_gedung, $kapasitas, $keterangan, $lokasi)) {
                    $_SESSION['message'] = ['type' => 'success', 'text' => 'Ruangan berhasil diperbarui.'];
                } else {
                    $_SESSION['message'] = ['type' => 'error', 'text' => 'Gagal mengupdate ruangan.'];
                }
            }
            header('Location: index.php?route=ruangan');
            exit;
        }

        $ruangan = RuanganModel::find($id);
        if (!$ruangan) {
            header('Location: index.php?route=ruangan');
            exit;
        }

        $gedungList = GedungModel::all();

        $view = BASE_PATH . '/app/views/ruangan/form_edit.php';
        if (!file_exists($view)) {
            die("❌ Error: File view tidak ditemukan: $view");
        }
        include $view;
    }

    public function delete() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        if ($id > 0) {
            RuanganModel::delete($id);
            $_SESSION['message'] = ['type' => 'success', 'text' => 'Ruangan berhasil dihapus.'];
        }
        header('Location: index.php?route=ruangan');
        exit;
    }
}