<?php
require_once __DIR__ . '/../models/MataKuliahModel.php';
require_once __DIR__ . '/../models/ProdiModel.php';

class MataKuliahController {
    public function index() {
        $q = trim($_GET['q'] ?? '');
        $id_prodi = (int)($_GET['id_prodi'] ?? 0);
        $prodiList = ProdiModel::all();

        if ($q === '' && $id_prodi === 0) {
            $list = MataKuliahModel::allWithProdi();
        } else {
            $list = MataKuliahModel::filter($q, $id_prodi);
        }
        require BASE_PATH . '/app/views/mk/index.php';
    }

    public function add() {
        $prodiList = ProdiModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nama = trim($_POST['nama_mk'] ?? '');
            $id_prodi = (int)($_POST['id_prodi'] ?? 0);
            $sks = (int)($_POST['sks'] ?? 0);

            if ($nama === '' || $id_prodi <= 0 || $sks < 1 || $sks > 3) {
                $_SESSION['flash'] = 'Semua field wajib diisi (SKS 1–3).';
                header("Location: index.php?route=mk_add"); exit;
            }
            if (MataKuliahModel::existsByNameProdi($nama, $id_prodi)) {
                $_SESSION['flash'] = 'Nama mata kuliah sudah ada di prodi tersebut.';
                header("Location: index.php?route=mk_add"); exit;
            }
            MataKuliahModel::create($nama, $id_prodi, $sks);
            $_SESSION['flash'] = 'Mata kuliah berhasil ditambahkan ✅';
            header("Location: index.php?route=mk"); exit;
        }

        require BASE_PATH . '/app/views/mk/form_add.php';
    }

    public function edit() {
        $id = (int)($_GET['id'] ?? 0);
        $data = MataKuliahModel::find($id);
        if (!$data) { $_SESSION['flash'] = 'Data tidak ditemukan.'; header("Location: index.php?route=mk"); exit; }

        $prodiList = ProdiModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nama = trim($_POST['nama_mk'] ?? '');
            $id_prodi = (int)($_POST['id_prodi'] ?? 0);
            $sks = (int)($_POST['sks'] ?? 0);

            if ($nama === '' || $id_prodi <= 0 || $sks < 1 || $sks > 3) {
                $_SESSION['flash'] = 'Semua field wajib diisi (SKS 1–3).';
                header("Location: index.php?route=mk_edit&id=".$id); exit;
            }
            if (MataKuliahModel::existsByNameProdi($nama, $id_prodi, $id)) {
                $_SESSION['flash'] = 'Nama mata kuliah sudah ada di prodi tersebut.';
                header("Location: index.php?route=mk_edit&id=".$id); exit;
            }
            MataKuliahModel::update($id, $nama, $id_prodi, $sks);
            $_SESSION['flash'] = 'Mata kuliah berhasil diperbarui ✨';
            header("Location: index.php?route=mk"); exit;
        }

        require BASE_PATH . '/app/views/mk/form_edit.php';
    }

    public function delete() {
        $id = (int)($_GET['id'] ?? 0);
        MataKuliahModel::delete($id);
        $_SESSION['flash'] = 'Mata kuliah berhasil dihapus 🗑️';
        header("Location: index.php?route=mk"); exit;
    }
}
