<?php

class KelasController {
    public function index() {
        $kelas = KelasModel::all();
        include BASE_PATH . '/app/views/kelas/index.php';
    }

    public function add() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $kode_kelas = trim($_POST['kode_kelas']);
            $id_prodi = (int)$_POST['id_prodi'];

            if (!empty($kode_kelas) && $id_prodi > 0) {
                if (KelasModel::create($kode_kelas, $id_prodi)) {
                    $_SESSION['message'] = ['type' => 'success', 'text' => 'Kelas berhasil ditambahkan.'];
                } else {
                    $_SESSION['message'] = ['type' => 'error', 'text' => 'Gagal menambahkan kelas.'];
                }
            } else {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Semua field wajib diisi.'];
            }
            header('Location: index.php?route=kelas');
            exit;
        }

        // Ambil daftar prodi untuk dropdown
        $prodiList = ProdiModel::all();
        include BASE_PATH . '/app/views/kelas/add.php';
    }

    public function edit() {
        $id = (int)($_GET['id'] ?? 0);
        $kelas = KelasModel::find($id);
        if (!$kelas) {
            header('Location: index.php?route=kelas');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $kode_kelas = trim($_POST['kode_kelas']);
            $id_prodi = (int)$_POST['id_prodi'];

            if (!empty($kode_kelas) && $id_prodi > 0) {
                if (KelasModel::update($id, $kode_kelas, $id_prodi)) {
                    $_SESSION['message'] = ['type' => 'success', 'text' => 'Kelas berhasil diupdate.'];
                } else {
                    $_SESSION['message'] = ['type' => 'error', 'text' => 'Gagal mengupdate kelas.'];
                }
            } else {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Semua field wajib diisi.'];
            }
            header('Location: index.php?route=kelas');
            exit;
        }

        // Ambil daftar prodi untuk dropdown
        $prodiList = ProdiModel::all();
        include BASE_PATH . '/app/views/kelas/edit.php';
    }

    public function delete() {
        $id = (int)($_GET['id'] ?? 0);
        if (KelasModel::delete($id)) {
            $_SESSION['message'] = ['type' => 'success', 'text' => 'Kelas berhasil dihapus.'];
        } else {
            $_SESSION['message'] = ['type' => 'error', 'text' => 'Gagal menghapus kelas.'];
        }
        header('Location: index.php?route=kelas');
        exit;
    }
}