<?php

require_once __DIR__ . '/../models/RuanganModel.php';
require_once __DIR__ . '/../models/HariModel.php';
require_once __DIR__ . '/../models/SlotModel.php';
require_once __DIR__ . '/../models/JadwalModel.php';
require_once __DIR__ . '/../models/MataKuliahModel.php';
require_once __DIR__ . '/../models/KelasModel.php';
require_once __DIR__ . '/../models/DosenModel.php';

class JadwalController {
    public function index() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        // ✅ Ambil semua jadwal langsung dari JadwalModel (tanpa filter)
        $list = JadwalModel::all();

        // Ambil data pendukung
        $ruangList = RuanganModel::all(); // pakai all(), bukan allWithGedung()
        $hariList = HariModel::all();
        $slotList = SlotModel::all();

        include BASE_PATH . '/app/views/jadwal/index.php';
    }

    public function edit() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        if ($id <= 0) {
            header('Location: index.php?route=jadwal');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id_hari = (int)($_POST['id_hari'] ?? 0);
            $id_slot = (int)($_POST['id_slot'] ?? 0);
            $id_ruangan = (int)($_POST['id_ruangan'] ?? 0);
            $id_mk = !empty($_POST['id_mk']) ? (int)$_POST['id_mk'] : null;
            $id_kelas = !empty($_POST['id_kelas']) ? (int)$_POST['id_kelas'] : null;
            $id_dosen = (int)($_POST['id_dosen'] ?? 0);
            $jumlah_sks = (int)($_POST['jumlah_sks'] ?? 1);
            $sumber = $_POST['sumber'] ?? 'tetap';
            $tanggal_mulai = !empty($_POST['tanggal_mulai']) ? $_POST['tanggal_mulai'] : null;
            $tanggal_selesai = !empty($_POST['tanggal_selesai']) ? $_POST['tanggal_selesai'] : null;

            if ($id_hari && $id_slot && $id_ruangan && $id_dosen && $jumlah_sks >= 1) {
                JadwalModel::update($id, [
                    'id_hari' => $id_hari,
                    'id_slot' => $id_slot,
                    'id_ruangan' => $id_ruangan,
                    'id_mk' => $id_mk,
                    'id_kelas' => $id_kelas,
                    'id_dosen' => $id_dosen,
                    'jumlah_sks' => $jumlah_sks,
                    'sumber' => $sumber,
                    'tanggal_mulai' => $tanggal_mulai,
                    'tanggal_selesai' => $tanggal_selesai,
                ]);
                $_SESSION['message'] = ['type' => 'success', 'text' => 'Jadwal berhasil diperbarui.'];
            } else {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Hari, slot, ruangan, dosen, dan SKS wajib diisi.'];
            }
            header('Location: index.php?route=jadwal');
            exit;
        }

        $jadwal = JadwalModel::find($id);
        if (!$jadwal) {
            header('Location: index.php?route=jadwal');
            exit;
        }

        $hariList = HariModel::all();
        $slotList = SlotModel::all();
        $ruangList = RuanganModel::all();
        $mkList = MataKuliahModel::all();
        $kelasList = KelasModel::all();
        $dosenList = DosenModel::all();

        include BASE_PATH . '/app/views/jadwal/edit.php';
    }

    public function delete() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        if ($id > 0) {
            JadwalModel::delete($id);
            $_SESSION['message'] = ['type' => 'success', 'text' => 'Jadwal berhasil dihapus.'];
        }
        header('Location: index.php?route=jadwal');
        exit;
    }
}