<?php
require_once __DIR__ . '/../models/DosenModel.php';

class DosenController {
    public function index() {
        $q = trim($_GET['q'] ?? '');
        $list = ($q === '') ? DosenModel::all() : DosenModel::search($q);
        require BASE_PATH . '/app/views/dosen/index.php';
    }

    public function add() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $inisial = strtoupper(trim($_POST['inisial'] ?? ''));
            $nama    = trim($_POST['nama_lengkap'] ?? '');

            if ($inisial === '' || $nama === '') {
                $_SESSION['flash'] = 'Semua field wajib diisi.';
                header("Location: index.php?route=dosen_add"); exit;
            }
            if (DosenModel::existsInisial($inisial)) {
                $_SESSION['flash'] = 'Inisial sudah digunakan.';
                header("Location: index.php?route=dosen_add"); exit;
            }
            DosenModel::create($inisial, $nama);
            $_SESSION['flash'] = 'Dosen berhasil ditambahkan ✅';
            header("Location: index.php?route=dosen"); exit;
        }
        require BASE_PATH . '/app/views/dosen/form_add.php';
    }

    public function edit() {
        $id   = (int)($_GET['id'] ?? 0);
        $data = DosenModel::find($id);
        if (!$data) { $_SESSION['flash'] = 'Data tidak ditemukan.'; header("Location: index.php?route=dosen"); exit; }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $inisial = strtoupper(trim($_POST['inisial'] ?? ''));
            $nama    = trim($_POST['nama_lengkap'] ?? '');

            if ($inisial === '' || $nama === '') {
                $_SESSION['flash'] = 'Semua field wajib diisi.';
                header("Location: index.php?route=dosen_edit&id=".$id); exit;
            }
            if (DosenModel::existsInisial($inisial, $id)) {
                $_SESSION['flash'] = 'Inisial sudah digunakan.';
                header("Location: index.php?route=dosen_edit&id=".$id); exit;
            }
            DosenModel::update($id, $inisial, $nama);
            $_SESSION['flash'] = 'Dosen berhasil diperbarui ✨';
            header("Location: index.php?route=dosen"); exit;
        }
        require BASE_PATH . '/app/views/dosen/form_edit.php';
    }

    public function delete() {
        $id = (int)($_GET['id'] ?? 0);
        DosenModel::delete($id);
        $_SESSION['flash'] = 'Dosen berhasil dihapus 🗑️';
        header("Location: index.php?route=dosen"); exit;
    }
}
