<?php
require_once __DIR__ . '/../models/BookingModel.php';
require_once __DIR__ . '/../models/RuanganModel.php';
require_once __DIR__ . '/../models/HariModel.php';
require_once __DIR__ . '/../models/SlotModel.php';
require_once __DIR__ . '/../models/DosenModel.php';
require_once __DIR__ . '/../models/MataKuliahModel.php';
require_once __DIR__ . '/../models/KelasModel.php';
require_once __DIR__ . '/../models/JadwalModel.php';
require_once __DIR__ . '/../models/LogModel.php';

class BookingController {

    public function index() {
        $idDosenFilter = 0;
        if (!empty($_SESSION['user']) && $_SESSION['user']['role'] === 'dosen') {
            $idDosenFilter = (int)($_SESSION['user']['id_dosen'] ?? 0);
        }

        $list = BookingModel::allWithJoins($idDosenFilter);
        require BASE_PATH . '/app/views/booking/index.php';
    }

    public function add() {
        $ruangList = RuanganModel::allWithGedung();
        $hariList  = HariModel::all();
        $slotList  = SlotModel::all();
        $dosenList = DosenModel::all();
        $mkList = MataKuliahModel::all();
        $kelasList = KelasModel::all();

        // ✅ Ambil data dari URL (jika ada)
        $defaultRuangan = (int)($_GET['ruangan'] ?? 0);
        $defaultHari = (int)($_GET['hari'] ?? 0);
        $defaultSlot = (int)($_GET['slot'] ?? 0);
        $defaultTanggal = trim($_GET['tanggal'] ?? '');

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $p = [
                'id_dosen'   => (int)($_POST['id_dosen'] ?? ($_SESSION['user']['id_dosen'] ?? 0)),
                'id_ruangan' => (int)($_POST['id_ruangan'] ?? 0),
                'id_hari'    => (int)($_POST['id_hari'] ?? 0),
                'id_slot'    => (int)($_POST['id_slot'] ?? 0),
                'jumlah_sks' => (int)($_POST['jumlah_sks'] ?? 1),
                'tanggal'    => trim($_POST['tanggal'] ?? ''),
                'mata_kuliah'=> trim($_POST['mata_kuliah'] ?? ''),
                'kelas'      => trim($_POST['kelas'] ?? ''),
                'keperluan'  => trim($_POST['keperluan'] ?? ''),
            ];

            foreach (['id_dosen','id_ruangan','id_hari','id_slot'] as $k) {
                if ($p[$k] <= 0) {
                    $_SESSION['flash'] = 'Semua field wajib diisi.';
                    header("Location:index.php?route=booking_add");
                    exit;
                }
            }

            if ($p['tanggal'] === '') {
                $_SESSION['flash'] = 'Tanggal wajib diisi.';
                header("Location:index.php?route=booking_add");
                exit;
            }

            // Cek bentrok (booking baru → excludeId = 0)
            if (BookingModel::isConflict($p, 0)) {
                $_SESSION['flash'] = 'Bentrok: ruangan/hari/slot pada tanggal tersebut sudah digunakan.';
                header("Location:index.php?route=booking_add");
                exit;
            }

            BookingModel::create($p);
            LogModel::write('booking_ruangan', 0, 'dibuat', $_SESSION['user']['username'] ?? 'user');

            $_SESSION['flash'] = 'Booking diajukan ✔️';
            header("Location:index.php?route=booking");
            exit;
        }

        // ✅ Kirim data default ke view
        require BASE_PATH . '/app/views/booking/form_add.php';
    }

    public function approve() {
        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang bisa menyetujui.';
            header("Location:index.php?route=booking");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        $bk = BookingModel::find($id);

        if (!$bk) {
            $_SESSION['flash'] = 'Booking tidak ditemukan.';
            header("Location:index.php?route=booking");
            exit;
        }

        if ($bk['status'] !== 'diajukan') {
            $_SESSION['flash'] = 'Status bukan diajukan.';
            header("Location:index.php?route=booking");
            exit;
        }

        // Paket untuk pengecekan
        $p = [
            'id_ruangan' => $bk['id_ruangan'],
            'id_hari'    => $bk['id_hari'],
            'id_slot'    => $bk['id_slot'],
            'tanggal'    => $bk['tanggal']
        ];

        // ❗ Penting: abaikan dirinya sendiri
        if (BookingModel::isConflict($p, $bk['id_booking'])) {
            $_SESSION['flash'] = 'Gagal setujui: bentrok jadwal.';
            header("Location:index.php?route=booking");
            exit;
        }

        $ok = JadwalModel::createFromBooking($bk);

        if (!$ok) {
            $_SESSION['flash'] = 'Gagal menulis ke tabel jadwal.';
            header("Location:index.php?route=booking");
            exit;
        }

        BookingModel::setStatus($id, 'disetujui');
        LogModel::write('booking_ruangan', $id, 'disetujui', $_SESSION['user']['username'] ?? 'admin');

        $_SESSION['flash'] = 'Booking disetujui ✔️ Jadwal dibuat.';
        header("Location:index.php?route=booking");
        exit;
    }

    public function reject() {
        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang bisa menolak.';
            header("Location:index.php?route=booking");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        $bk = BookingModel::find($id);

        if (!$bk) {
            $_SESSION['flash'] = 'Booking tidak ditemukan.';
            header("Location:index.php?route=booking");
            exit;
        }

        BookingModel::setStatus($id, 'ditolak');
        LogModel::write('booking_ruangan', $id, 'ditolak', $_SESSION['user']['username'] ?? 'admin');

        $_SESSION['flash'] = 'Booking ditolak.';
        header("Location:index.php?route=booking");
        exit;
    } 
}